//
//  InterstitialViewController.m
//  AdViewSDKDemo
//
//  Created by unakayou on 11/1/19.
//  Copyright © 2019 AdView. All rights reserved.
//

#import "InterstitialViewController.h"

@interface InterstitialViewController () <AdViewViewDelegate>
@property (nonatomic, strong) AdViewView * interstitial;
@property (nonatomic) BOOL isReady;
@end

@implementation InterstitialViewController

- (void)requestButtonClick:(UIButton *)sender {
    if(self.isReady) {
            [self.interstitial showInterstitialWithRootViewController:[UIApplication sharedApplication].keyWindow.rootViewController];
       }else {
            self.interstitial = [AdViewView requestAdInterstitialWithPositionId:ADVIEW_POSID_INTERSTITIAL
                                                                       delegate:self];
    }
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    self.isReady = NO;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    if(!self.interstitial) {
        self.interstitial = [AdViewView requestAdInterstitialWithPositionId:ADVIEW_POSID_INTERSTITIAL
                                                                   delegate:self];
    }
}

- (NSString *)appId {
    return ADVIEW_APPID;
}

- (UIViewController *)viewControllerForShowModal {
    return self;
}

- (void)didReceivedAd:(AdViewView *)adView {
    self.requestButton.text = [NSString stringWithFormat:@"%@ %@", NSLocalizedString(@"DISPLAY", nil),
                                  [NSStringFromClass(self.class) stringByReplacingOccurrencesOfString:@"ViewController"
                                                                                           withString:@""]];
    self.isReady = YES;
}
- (void)adViewDidDisplayAd:(AdViewView *)adView {
    
    NSLog(@"%s",__FUNCTION__);
    NSLog(@"Already Displayed");
}
- (void)didFailToReceiveAd:(AdViewView *)adView Error:(NSError *)error {
    NSLog(@"%s - %@",__FUNCTION__, error.domain);
}

- (void)adViewWillPresentScreen:(AdViewView *)adView {
    NSLog(@"%s", __FUNCTION__);
}
- (void)adViewDidDismissScreen:(AdViewView *)adView {
    self.isReady = NO;
    self.requestButton.text = [NSString stringWithFormat:@"%@ %@", NSLocalizedString(@"REQ", nil),
                               [NSStringFromClass(self.class) stringByReplacingOccurrencesOfString:@"ViewController"
                                                                                        withString:@""]];
    self.interstitial = nil;
    NSLog(@"%s", __FUNCTION__);
}
- (void)adViewDidFinishShow:(AdViewView *)adview {
    NSLog(@"%s", __FUNCTION__);
}
- (void)adViewdidFailToDisplayAd:(AdViewView *)adView Error:(NSError*)error {
    NSLog(@"%s",__FUNCTION__);
    NSLog(@"%@", error);
    
}




@end
