/*
 * AdViewVPAIDBridge.js
 *
 */

var AdView_timer = null;
var AdView_creative = null;
var initAdViewVPAIDBridge = function() {
		_creative = getVPAIDAd();
        setCallbacksForCreative();
		console.namespace = "VPAID";
        return (_creative != null);
}

var callNative = function(method, args) {
    	bridge.callNative("VPAID", method, args);
};

var checkVPAIDInterface = function() {
	if(_creative.handshakeVersion
		&& typeof _creative.handshakeVersion == "function"
        && _creative.initAd && typeof _creative.initAd == "function"
        && _creative.startAd && typeof _creative.startAd == "function"
        && _creative.stopAd && typeof _creative.stopAd == "function"
        && _creative.skipAd && typeof _creative.skipAd == "function"
        && _creative.resizeAd && typeof _creative.resizeAd == "function"
        && _creative.pauseAd && typeof _creative.pauseAd == "function"
        && _creative.resumeAd && typeof _creative.resumeAd == "function"
        && _creative.expandAd && typeof _creative.expandAd == "function"
        && _creative.collapseAd && typeof _creative.collapseAd == "function"
        && _creative.subscribe && typeof _creative.subscribe == "function"
        && _creative.unsubscribe && typeof _creative.unsubscribe == "function") {
        	return true;
    }
    return false;
}

var handshakeVersion = function (version) {
        return _creative.handshakeVersion(version);
}

var initAd = function(width, height, viewMode, desiredBitrate, creativeData) {
        var environmentVars = {};
        environmentVars["slot"] = document.getElementById('AdView-slot');
        environmentVars["videoSlot"] = document.getElementById('AdView-videoslot');
        _creative.initAd(width, height, viewMode, desiredBitrate, creativeData, environmentVars);
};

var onAdPaused = function() {
        console.log("onAdPaused");
        callNative("vpaidAdPaused");
};

var onAdPlaying = function() {
		console.log("onAdPlaying");
        callNative("vpaidAdPlaying");
};

var onAdError = function(message) {
        console.log("onAdError: " + message);
        callNative("vpaidAdError",{"error":message});
};

var onAdLog = function(message) {
        console.log("onAdLog: " + message);
        callNative("vpaidAdLog",{"log":message});
};

var onAdUserAcceptInvitation = function() {
        console.log("onAdUserAcceptInvitation");
        callNative("vpaidAdUserAcceptInvitation");
};

var onAdUserMinimize = function() {
        console.log("onAdUserMinimize");
        callNative("vpaidAdUserMinimize");
};

var onAdUserClose = function() {
        console.log("onAdUserClose");
        callNative("vpaidAdUserClose");
};

var onAdSkippableStateChange = function() {
        console.log("Ad Skippable State Changed to: " + _creative.getAdSkippableState());
        callNative("vpaidAdSkippableStateChange");
};

var onAdExpandedChange = function() {
        console.log("Ad Expanded Changed to: " + _creative.getAdExpanded());
        callNative("vpaidAdExpandedChange");
};

var getAdExpanded = function() {
        console.log("getAdExpanded");
		return _creative.getAdExpanded();
};

var getAdSkippableState = function() {
        console.log("getAdSkippableState");
        return _creative.getAdSkippableState();
};

var onAdSizeChange = function() {
        console.log("Ad size changed to: w=" + _creative.getAdWidth() + " h=" + _creative.getAdHeight());
        callNative("vpaidAdSizeChange");
};

var onAdDurationChange = function() {
         console.log("Ad Duration Changed to: " + _creative.getAdDuration());
        callNative("vpaidAdDurationChange");
};

var onAdRemainingTimeChange = function() {
         console.log("Ad Remaining Time Changed to: " + _creative.getAdRemainingTime());
        callNative("vpaidAdRemainingTimeChange");
};

var getAdRemainingTime = function() {
        return _creative.getAdRemainingTime();
};

var onAdImpression = function() {
        console.log("Ad Impression");
        callNative("vpaidAdImpression");
};

var onAdClickThru = function(url, id, playerHandles) {
        console.log("Clickthrough portion of the ad was clicked");
        var adjustedUrl = url;
        if (adjustedUrl == undefined)
            adjustedUrl = ""
        callNative("vpaidAdClickThru",{"id" : id, "url": adjustedUrl, "playerHandles": playerHandles});
};

var onAdInteraction = function(id) {
        console.log("A non-clickthrough event has occured");
        callNative("vpaidAdInteraction", {"id": id});
};

var onAdVideoStart = function() {
        console.log("Video 0% completed");
        callNative("vpaidAdVideoStart");
};

var onAdVideoFirstQuartile = function() {
        console.log("Video 25% completed");
        callNative("vpaidAdVideoFirstQuartile");
};

var onAdVideoMidpoint = function() {
        console.log("Video 50% completed");
        callNative("vpaidAdVideoMidpoint");
};

var onAdVideoThirdQuartile = function() {
        console.log("Video 75% completed");
        callNative("vpaidAdVideoThirdQuartile");
};

var onAdVideoComplete = function() {
        console.log("Video 100% completed");
        callNative("vpaidAdVideoComplete");
};

var onAdLinearChange = function() {
        console.log("Ad linear has changed: " + _creative.getAdLinear());
        callNative("vpaidAdLinearChange");
};

var getAdLinear = function() {
        console.log("getAdLinear");
        return _creative.getAdLinear();
};

var getAdDuration = function() {
        console.log("getAdDuration");
        return _creative.getAdDuration();
};

var onAdLoaded = function() {
        console.log("ad has been loaded");
        callNative("vpaidAdLoaded");
};

var onAdStarted = function() {
        console.log("Ad has started");
        timer = setInterval(function() {

            // 播放进度回传
            var duration = getAdDuration();
            var remainingTime = getAdRemainingTime();
            callNative("vpaidProgressChanged",{"duration": duration, "remainingTime": remainingTime});
        }.bind(this), 500);
        callNative("vpaidAdStarted");
};

var onAdStopped = function() {
        console.log("Ad has stopped");
        clearInterval(timer);
        callNative("vpaidAdStopped");
};

var onAdSkipped = function() {
        console.log("Ad was skipped");
        callNative("vpaidAdSkipped");
};

var setAdVolume = function(val) {
		_creative.setAdVolume(val);
};

var getAdVolume = function() {
       return _creative.getAdVolume();
};

var onAdVolumeChange = function() {
        console.log("Ad Volume has changed to - " + _creative.getAdVolume());
        callNative("vpaidAdVolumeChanged");
};

var startAd = function() {
    	_creative.startAd();
};

var skipAd = function() {
        _creative.skipAd();
};

var stopAd = function() {
        _creative.stopAd();
};

var resizeAd = function(width, height, viewMode) {
        _creative.resizeAd(width, height, viewMode);
};

var pauseAd = function() {
        _creative.pauseAd();
};

var resumeAd = function() {
        _creative.resumeAd();
};

var expandAd = function() {
        _creative.expandAd();
};

var collapseAd = function() {
        _creative.collapseAd();
};

var onAdSkipPress = function() {
        _creative.skipAd();
}

var setCallbacksForCreative = function() {
        var callbacks = {
            'AdStarted' : onAdStarted,
            'AdStopped' : onAdStopped,
            'AdSkipped' : onAdSkipped,
            'AdLoaded' : onAdLoaded,
            'AdLinearChange' : onAdLinearChange,
            'AdSizeChange' : onAdSizeChange,
            'AdExpandedChange' : onAdExpandedChange,
            'AdSkippableStateChange' : onAdSkippableStateChange,
            'AdDurationChange' : onAdDurationChange,
            'AdRemainingTimeChange' : onAdRemainingTimeChange,
            'AdVolumeChange' : onAdVolumeChange,
            'AdImpression' : onAdImpression,
            'AdClickThru' : onAdClickThru,
            'AdInteraction' : onAdInteraction,
            'AdVideoStart' : onAdVideoStart,
            'AdVideoFirstQuartile' : onAdVideoFirstQuartile,
            'AdVideoMidpoint' : onAdVideoMidpoint,
            'AdVideoThirdQuartile' : onAdVideoThirdQuartile,
            'AdVideoComplete' : onAdVideoComplete,
            'AdUserAcceptInvitation' : onAdUserAcceptInvitation,
            'AdUserMinimize' : onAdUserMinimize,
            'AdUserClose' : onAdUserClose,
            'AdPaused' : onAdPaused,
            'AdPlaying' : onAdPlaying,
            'AdError' : onAdError,
            'AdLog' : onAdLog
        };

        // 把调用native的方法,注册到广告JS中
        for (var eventName in callbacks) {
            _creative.subscribe(callbacks[eventName], eventName, this);
        }
};
