package com.adviewbid.demo;

import android.Manifest;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.provider.Settings;
//import android.support.v4.app.ActivityCompat;
//import android.support.v4.content.ContextCompat;
import androidx.core.app.ActivityCompat; //androidx使用
import androidx.core.content.ContextCompat; ////androidx使用

import android.view.View;
import android.view.View.OnClickListener;
import android.widget.LinearLayout;
import android.widget.Toast;

//import com.advg.loader.AdViewSdk;
import com.adviewbid.demo.R;

import java.util.List;

/**
 * MainActivity
 * @author YYZ
 *
 */
public class MainActivity extends Activity implements OnClickListener {

	private LinearLayout banner = null;
	private LinearLayout banner_mrec = null;
	private LinearLayout mrec_video = null;
	private LinearLayout instl = null;
	private LinearLayout natives = null;
	private LinearLayout video = null;
	private LinearLayout video2 = null;

	private LinearLayout spread = null;

	public String[] permissions = null;

	//adview test ids
	public static final String offical_APPID = "SDK20240917090454ylsxonvikfym8kc"; //fillrate high
	public static final String offical_Video_POSID = "POSIDm1b98xvmdank";
	public static final String offical_mrec_video_POSID = "POSIDfa6pwb2q8yrk";
	public static final String offical_spread_POSID = "POSID7p6ytw77tk2r";
	public static final String offical_instl_POSID = "POSIDpxu87lilsnim";
	public static final String offical_banner_POSID = "POSIDp4pf6w0od8ab";
	public static final String offical_mrec_posid = "POSIDkvdbdr9dv8e6";
	public static final String offical_native_posid = "POSIDwaimmqt4afhy";

	public static String Gdpr = "BOEFEAyOEFEAyAHABDENAI4AAAB9vABAASA";
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		banner = findViewById(R.id.banner);
		banner_mrec = findViewById(R.id.banner_mrec);
		mrec_video = findViewById(R.id.mrec_video);
		instl = findViewById(R.id.instl);
		natives = findViewById(R.id.natives);
		video = findViewById(R.id.video);
		video2 = findViewById(R.id.video2);
        spread = findViewById(R.id.spread);

		requestPermission();
		//makePreferenceKeys(); //test for CCPA ,you only need do it once
//		AdViewSdk.initialize(this);
//		AdViewSdk.setCoppa(true);
//		AdViewSdk.setTestMode(false);
//		AdViewSdk.setGDPR2(1,
//					MainActivity.Gdpr);
	}

	private void onPermissionGranted() {
		banner.setOnClickListener(this);
		banner_mrec.setOnClickListener(this);
		mrec_video.setOnClickListener(this);
		instl.setOnClickListener(this);
		natives.setOnClickListener(this);
		video.setOnClickListener(this);
		video2.setOnClickListener(this);
		spread.setOnClickListener(this);
	}


	@Override
	public void onClick(View v) {
		switch (v.getId()) {
			case R.id.spread:
				startActivity(new Intent(this, AdSpreadActivity.class));
			break;
			case R.id.banner:
				 Intent intent = new Intent(this, AdBannerActivity.class);
				 intent.putExtra("banner_mode", 0);
				 intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
				 startActivity(intent);
				break;
			case R.id.banner_mrec:
				Intent intent2 = new Intent(this, AdBannerActivity.class);
				intent2.putExtra("banner_mode", 1);
				intent2.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
				startActivity(intent2);
				break;
			case R.id.mrec_video:
				Intent intent5 = new Intent(this, AdBannerActivity.class);
				intent5.putExtra("banner_mode", 2);
				intent5.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
				startActivity(intent5);
				break;
			case R.id.instl:
				startActivity(new Intent(this, AdInstlActivity.class));
				break;
			case R.id.video:
				Intent intent7 = new Intent(this, AdVideoActivity.class);
				intent7.putExtra("two_steps", 0);
				intent7.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
				startActivity(intent7);
				break;
			case R.id.video2:
				Intent intent6 = new Intent(this, AdVideoActivity.class);
				intent6.putExtra("two_steps", 1);
				intent6.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
				startActivity(intent6);

				break;
			case R.id.natives:
				Intent intent3 = new Intent(this, AdNativeActivity.class);
				intent3.putExtra("native_mode", 0);
				intent3.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
				startActivity(intent3);
				//startActivity(new Intent(this, AdNativeActivity.class));
				break;

		}
	}

	////////////////////////permission /////////////////////////////////////
	public void requestPermission() {
		////pls confirm your App's targetSDKVersion >= 23，also must set "READ_PHONE_STATE"、"WRITE_EXTERNAL_STORAGE"、"ACCESS_FINE_LOCATION" permissions,
		//pls see manifest.xml
		if (Build.VERSION.SDK_INT >= 23) {
			permissions = new String[]{
					Manifest.permission.INTERNET,
				};

			for (String permission : permissions) {
				if (ContextCompat.checkSelfPermission(this, permission) != PackageManager.PERMISSION_GRANTED) {
					// if one failed, return  false
					//no permission, ask for permissions
					ActivityCompat.requestPermissions(this, permissions, 1);
					return;
				}
			}
			//all granted
			onPermissionGranted();
		}else {
			//all granted
			onPermissionGranted();
		}
	}
	@Override
	public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
		//requestCode, used to identify which is same request
		if (requestCode == 1){
			boolean isAllGranted = true;

			// is all permissons granted
			for (int grant : grantResults) {
				if (grant != PackageManager.PERMISSION_GRANTED) {
					isAllGranted = false;
					break;
				}
			}

			if (isAllGranted) {
				//all granted
				onPermissionGranted();
			} else {
				// popup window to show user to get permissions
				openAppDetails();
			}

		}
	}

	private void makePreferenceKeys() {
		try {
			SharedPreferences mPreferences = PreferenceManager.getDefaultSharedPreferences(this);
			SharedPreferences.Editor editor = mPreferences.edit(); //important!! not use mPreferences.edit() or will be not saved
			editor.clear();
			editor.putString("IABUSPrivacy_String", "1---");

			//GDPR-1.0
            editor.putString("IABConsent_SubjectToGDPR", "0");
            editor.putString("IABConsent_ConsentString", "COAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");

			//GDPR-TCF2.0 test
//			editor.putString("IABTCF_TCString", "COEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE");
//			editor.putInt("IABTCF_gdprApplies", 1);

			//GPP string
			editor.putString("IABGPP_HDR_GppString", "GPPBBBBBBBBBBBBBBBBBBBD");
			editor.putString("IABGPP_GppSID", "99");

			editor.commit();
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
	private void openAppDetails() {
		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setMessage("Permission Denied，Please granted them in  app info -> permissions ");
		builder.setPositiveButton("Grant", new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				Intent intent = new Intent();
				intent.setAction(Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
				intent.addCategory(Intent.CATEGORY_DEFAULT);
				intent.setData(Uri.parse("package:" + getPackageName()));
				intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
				intent.addFlags(Intent.FLAG_ACTIVITY_NO_HISTORY);
				intent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS);
				startActivity(intent);
			}
		});
		builder.setNegativeButton("Cancel", null);
		builder.show();
	}
}
