package com.adviewbid.demo;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.advg.loader.AdViewVideoManager;
import com.advg.loader.loaderInterface.AdViewVideoListener;
import com.adviewbid.demo.R;

import java.io.Serializable;

/**
 * video
 * @author YYZ
 *
 */
public class AdVideoActivity extends Activity implements OnClickListener {

	private Button nextVideo = null;
	private Button video_back = null;
	private AdViewVideoManager videoManager = null;
	private AdViewVideoListener advListener;

	private boolean two_steps = false; //2023 for 2 steps

	public final static String TAG = "AdViewVideoBID";

	private void requestAd() {

		if (two_steps) {
			//模式：2步加载
			videoManager = new AdViewVideoManager(
					//this,
					getApplication().getApplicationContext(),
					MainActivity.offical_APPID,
					MainActivity.offical_Video_POSID,
					advListener);
		}else {
			videoManager = new AdViewVideoManager(this,
					MainActivity.offical_APPID,
					MainActivity.offical_Video_POSID,
					advListener,
					false);
		}


//		videoManager.setGDPR2(1,
//				MainActivity.Gdpr);

		// screen orientation , pls refer to ActivityInfo.SCREEN_XXXXXX definition
		if (videoManager != null)
			videoManager.setVideoOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		int mode  = getIntent().getExtras().getInt("two_steps", -1);
		if (mode == 1)
			two_steps = true;

		setContentView(R.layout.activity_video);

		nextVideo = (Button) findViewById(R.id.video_change);
		video_back = (Button) findViewById(R.id.video_back);
		nextVideo.setOnClickListener(this);
		video_back.setOnClickListener(this);

		setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);//竖屏

		nextVideo.setVisibility(View.GONE);//default is none,only for 2 steps

		advListener = new com.advg.loader.loaderInterface.AdViewVideoListener() {
			@Override
			public void onFailedReceivedVideo(String error) {
				Log.i(TAG, "onFailedRecievedVideo:"+error);
				popupInfo(error);
//		nextVideo.setEnabled(true);
			}
			@Override
			public void onVideoStartPlayed() {

				Log.i(TAG, "++++++++++++ [app]onVideoStartPlayed ++++++++++");
			}
			@Override
			public void onVideoFinished() {
				Log.i(TAG, "++++++++++++[app] onVideoFinished ++++++++++++");
			}
			@Override
			public void onVideoClosed() {
				Log.i(TAG, "++++++++++++[app] onVideoClosed ++++++++++++");

				setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);//竖屏
			}
			@Override
			public void onPlayedError(String arg0) {
				Log.i(TAG, "onPlayedError:"+arg0);
			}
			@Override
			public void onReceivedVideo(String arg0) {
				Log.i(TAG, "onRecievedVideo:"+arg0);
			}
			@Override
			public void onVideoReady() {
				Log.i(TAG, "onVideoReady");

				//2 steps enabled
				if (two_steps) {
					nextVideo.setVisibility(View.VISIBLE);
				}
			}
			@Override
			public void onVideoClicked(int downX, int downY) {
				Log.i(TAG, "[AdVideoActivity]--- onVideoClicked ----");
			}
		};

		requestAd();
	}

	@Override
	public void onClick(View v) {
		switch (v.getId()) {
		case R.id.video_back:
			this.finish();
			break;
		case R.id.video_change:
			Log.i(TAG, "clickButton");
			//2 steps use follows
			if (two_steps) {
				videoManager.showVideo(this);
				nextVideo.setVisibility(View.GONE);
			}
			break;
		}
	}

	public static int dip2px(Context context, float dpValue) {
		final float scale = context.getResources().getDisplayMetrics().density;
		return (int) (dpValue * scale + 0.5f);
	}


	private void popupInfo(String code) {
		AlertDialog.Builder builder;
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
			builder = new AlertDialog.Builder(this, android.R.style.Theme_Material_Dialog_Alert);
		} else {
			builder = new AlertDialog.Builder(this);
		}
		builder.setTitle("Failed to load adview banner ad")
				.setMessage("Error code: \n" + code)
				.setIcon(android.R.drawable.ic_dialog_alert)
				.show();
	}
}
