package com.adviewbid.demo;

import java.lang.reflect.Field;
import java.util.List;

import com.advg.loader.AdViewSpreadManager;
import com.advg.loader.InitSDKManager;
import com.advg.loader.loaderInterface.AdViewSpreadListener;
import com.adviewbid.demo.R;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.View.OnClickListener;
import android.view.Window;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.RelativeLayout.LayoutParams;
import android.widget.TextView;
import android.widget.Toast;

/**
 * spread ads
 * @author YYZ
 *
 */
public class AdSpreadActivity extends Activity  {
	private AdViewSpreadManager adSpreadBIDView = null;
	private int count = 1;
	private AdViewSpreadListener advListener;
	private Context mCtx = null;

	private boolean isPausing = false; //20210527
	private void requestSpreadAd(){
		adSpreadBIDView = new AdViewSpreadManager(
				this,
				//getApplication().getApplicationContext(),
				MainActivity.offical_APPID,
				MainActivity.offical_spread_POSID,
				(RelativeLayout) findViewById(R.id.spreadlayout));

//		adSpreadBIDView.setGDPR2(1,
//				MainActivity.Gdpr);
		adSpreadBIDView.setLogo(R.drawable.logo);
		adSpreadBIDView.setBackgroundColor(Color.WHITE);
		adSpreadBIDView.setSpreadNotifyType(AdViewSpreadManager.NOTIFY_COUNTER_CUSTOM);


		adSpreadBIDView.setOnAdViewListener(advListener);
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) { 
		super.onCreate(savedInstanceState);
		mCtx = this;

		requestWindowFeature(Window.FEATURE_NO_TITLE);
		getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,WindowManager.LayoutParams.FLAG_FULLSCREEN);
		setContentView(R.layout.spread_layout);

		advListener = new com.advg.loader.loaderInterface.AdViewSpreadListener() {
			@SuppressLint("ResourceType")
			@Override
			public void onAdNotifyCustomCallback( final int ruleTime,final  int delayTime) {
				final TextView counterInfo = new TextView(mCtx);
				final Button btnSkip = new Button(mCtx);
				final LayoutParams btnLp = new LayoutParams(LayoutParams.WRAP_CONTENT,
						LayoutParams.WRAP_CONTENT);
				final LayoutParams tvLp = new LayoutParams(LayoutParams.WRAP_CONTENT,
						LayoutParams.WRAP_CONTENT);

				counterInfo.setTextSize(TypedValue.COMPLEX_UNIT_SP, 18);
				btnSkip.setTextSize(TypedValue.COMPLEX_UNIT_SP, 18);

				btnSkip.setId(123123);

				counterInfo.setBackgroundColor(Color.WHITE);
				btnSkip.setBackgroundColor(Color.TRANSPARENT);

				btnSkip.setText("Skip");
				counterInfo.setText(ruleTime + delayTime + "");

				btnLp.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
				tvLp.addRule(RelativeLayout.LEFT_OF, btnSkip.getId());

				adSpreadBIDView.getParentLayout().postDelayed(new Runnable() {
					@Override
					public void run() {
						btnSkip.setVisibility(View.VISIBLE);
						btnSkip.setOnClickListener(new OnClickListener() {
							@Override
							public void onClick(View v) {
								adSpreadBIDView.cancelAd();
							}
						});
					}
				}, ruleTime * 1000);

				adSpreadBIDView.getParentLayout().postDelayed(new Runnable() {
					@Override
					public void run() {
						if (isPausing) {
							Log.i("AdViewBID", "[SpreadAPP] --------timer counter PAUSING !!! ---------");
							adSpreadBIDView.getParentLayout().postDelayed(this, 1000);
							return;
						}
						if (ruleTime + delayTime - count >= 1) {
							counterInfo.setBackgroundColor(Color.WHITE);
							counterInfo.setText(ruleTime + delayTime - count + "");
							count++;
							adSpreadBIDView.getParentLayout().postDelayed(this, 1000);
						}else{
							//time is up
							Log.i("AdViewBID", "[SpreadAPP] --------time is up !!!! ---------");

							//((Activity)getBaseContext()).finish();
							doTimeoutAction();
						}
					}
				}, 1000);

				adSpreadBIDView.getParentLayout().addView(btnSkip, btnLp);
				adSpreadBIDView.getParentLayout().addView(counterInfo, tvLp);
				btnSkip.setVisibility(View.INVISIBLE);
			}

			@Override
			public void onAdClicked() {
				Log.i("AdViewBID", "[SpreadAPP] --------onAdClicked ---------");
			}

			@Override
			public void onAdClosed() {
				Log.i("AdViewBID", "[SpreadAPP] --------onAdClosedAd ---------");
						onClose();
			}

			@Override
			public void onAdClosedByUser() {
				Log.i("AdViewBID", "[SpreadAPP] -------- onAdClosedByUser -----------");

						onClose();
			}
			@Override
			public void onAdDisplayed() {

				Log.i("AdViewBID", "[SpreadAPP] --------onAdDisplayed--------------");
			}
			@Override
			public void onAdFailedReceived(String arg1) {
				Log.i("AdSpreadActivity", "+++++++++++ onAdRecieveFailed: " + arg1 + "++++++++++");

				/* for test */
				if (arg1.contains("Custom://")) {
					Log.i("AdSpreadActivity", "+++++++++++++++ :" + arg1 + "++++++++++++");
				}else {
					popupInfo(arg1);
				}
				onClose();
			}
			@Override
			public void onAdReceived() {

				Log.i("AdViewBID", "[SpreadAPP] --------onAdRecieved -----------");
			}

			@Override
			public void onAdSpreadPrepareClosed() {
				Log.i("AdViewBID", "[SpreadAPP] --------onAdSpreadPrepareClosed -----------");
				doTimeoutAction();
			}

		};

		requestSpreadAd();

	}
	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		if (keyCode == KeyEvent.KEYCODE_BACK)
			return false;
		return super.onKeyDown(keyCode, event);
	}

	//sdk timeout , and prepare next action
	private void doTimeoutAction() {

		Log.i("AdViewBID", "[SpreadAPP] --------doTimeoutAction -----------");
		//pausing ignore
		if (isPausing) {
			Log.i("AdViewBID", "[SpreadAPP] --------still pausing  -----------");
			return;
		}
		onClose();

		/*
		//[remove before release]
		//20200528 BackActivity
		Intent intent5 = new Intent(AdSpreadActivity.this,
				BackActivity.class
		);
		//intent5.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
		startActivity(intent5);
		//[end remove before release]
		*/
	}
	private void onClose() {
		this.finish();
	}

	

	//for life cycle
	@Override
	protected void onPause() {
		super.onPause();

		Log.i("AdViewBID","#### [SpreadAPP] AdSpreadActivity: onPause() ####");

		isPausing = true;
	}

	@Override
	protected void onResume() {
		super.onResume();
		Log.i("AdViewBID","#### [SpreadAPP] AdSpreadActivity: onResume() ####");
		isPausing = false;
	}

	@Override
	protected void onStop() {
		super.onStop();
		Log.i("AdViewBID","#### [SpreadAPP] AdSpreadActivity: onStop() ####");
	}


	private void popupInfo(String code) {
		AlertDialog.Builder builder;
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
			builder = new AlertDialog.Builder(this, android.R.style.Theme_Material_Dialog_Alert);
		} else {
			builder = new AlertDialog.Builder(this);
		}
		builder.setTitle("Failed to load adview banner ad")
				.setMessage("Error code: \n" + code)
				.setIcon(android.R.drawable.ic_dialog_alert)
				.show();
	}

	}
