package com.adviewbid.demo;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import com.advg.loader.AdViewInstlManager;
import com.advg.loader.loaderInterface.AdViewInstlListener;
import com.advg.utils.ConstantValues;
import com.adviewbid.demo.R;

/**
 * Instl ad
 * @author YYZ
 *
 */
public class AdInstlActivity extends Activity implements OnClickListener {

	private Button nextInstl = null;
	private Button insert_back = null;
	private AdViewInstlManager adInstlBIDView = null;
	private AdViewInstlListener advListener;

	private Context mCtx = null;
	private boolean adIsReady = false;

	protected void requestInstlAd() {
		adInstlBIDView = new AdViewInstlManager(
				//this,
				getApplication().getApplicationContext(),
				MainActivity.offical_APPID,
				MainActivity.offical_instl_POSID,
				true //close:true，none-close:false
		);

//		adInstlBIDView.setGDPR2(1,
//				MainActivity.Gdpr
//		);
		adInstlBIDView.setOnAdViewListener(advListener);

	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_insert);

		mCtx = this;
		//mCtx = getApplication().getApplicationContext();

		nextInstl =  findViewById(R.id.instl_change);
		insert_back =  findViewById(R.id.insert_back);
		nextInstl.setOnClickListener(this);
		insert_back.setOnClickListener(this);

		nextInstl.setVisibility(View.GONE);

		advListener = new com.advg.loader.loaderInterface.AdViewInstlListener() {
			@Override
			public void onAdClicked() {
				Log.i("AdInstlActivity", "onAdClicked");
			}

			@Override
			public void onAdClosed() {
				Log.i("AdInstlActivity", "onAdClosedAd");
			}

			@Override
			public void onAdReady() {
				Log.i("AdInstlActivity", "onAdReady");
				/**
				 * 1.normal show mode
				 */
				//adInstlBIDView.showInstl(mCtx);
				nextInstl.setVisibility(View.VISIBLE);
				adIsReady = true;
			}

			@Override
			public void onAdDisplayed() {
				Log.i("AdInstlActivity", "onDisplayed");
			}

			@Override
			public void onAdFailedReceived( String arg1) {

				if (arg1.contains("Custom://")) {
					Log.i("AdInstlActivity", "onAdRecieveFailed："+arg1);
				}else {
					popupInfo(arg1);
				}
			}

			@Override
			public void onAdReceived() {
				Log.i("AdInstlActivity", "onAdRecieved");
			}
		};

		requestInstlAd();
	}

	@Override
	public void onClick(View v) {
		switch (v.getId()) {
			case R.id.insert_back:
				this.finish();
				break;
			case R.id.instl_change:
				if (adIsReady) {
					adInstlBIDView.showInstl(mCtx);
					nextInstl.setVisibility(View.GONE);
					adIsReady = false;
				}
				break;
			default:
				break;
		}

	}

	public static int dip2px(Context context, float dpValue) {
		final float scale = context.getResources().getDisplayMetrics().density;
		return (int) (dpValue * scale + 0.5f);
	}

	@Override
	public void onPointerCaptureChanged(boolean hasCapture) {

	}

	private void popupInfo(String code) {
		AlertDialog.Builder builder;
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
			builder = new AlertDialog.Builder(this, android.R.style.Theme_Material_Dialog_Alert);
		} else {
			builder = new AlertDialog.Builder(this);
		}
		builder.setTitle("Failed to load adview banner ad")
				.setMessage("Error code: \n" + code)
				.setIcon(android.R.drawable.ic_dialog_alert)
				.show();
	}

}
