package com.adviewbid.demo;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.Button;
//import android.widget.FrameLayout.LayoutParams;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;

import com.advg.loader.AdViewBannerManager;
import com.advg.loader.loaderInterface.AdViewBannerListener;
import com.adviewbid.demo.R;


/**
 * banner
 * @author YYZ
 *
 */
public class AdBannerActivity extends Activity implements OnClickListener {
	private AdViewBannerManager adViewBIDView = null;
	private LinearLayout layout = null;

	private Button nextAd = null;
	private LinearLayout codeAd = null;
	private Button banner_back = null;
    private Button banner_hide = null;

	private String posID = "";
	private String appID = "";
	private boolean isMREC = false;
	private boolean isVideo = false;

	private int refreshTime = -1;
	private AdViewBannerListener advListener;
	private int fullHeight = 0;
	private void requestBanner() {

			//adViewBIDView = null;
			int adSize = AdViewBannerManager.BANNER_AUTO_FILL;
			if (isMREC || isVideo) {
				adSize = AdViewBannerManager.BANNER_MREC;
			}else {
				adSize = AdViewBannerManager.BANNER_AUTO_FILL;
			}

			if (isVideo) {
				appID = MainActivity.offical_APPID;
				posID = MainActivity.offical_mrec_video_POSID;
			}else {
				appID = MainActivity.offical_APPID;
				if (isMREC)
					posID = MainActivity.offical_mrec_posid;
				else
					posID = MainActivity.offical_banner_POSID;
			}
			adViewBIDView = new AdViewBannerManager(
					this,
					//getApplication().getApplicationContext(),
					appID,
					posID,
					adSize,
					false);

//			adViewBIDView.setGDPR2(0,
//					MainActivity.Gdpr
//			);

			adViewBIDView.setRefreshTime(refreshTime);
			if (isVideo)
				adViewBIDView.setVideoMode(true);


			adViewBIDView.setOnAdViewListener(advListener);
			if (null != banner_hide)
				banner_hide.setText(R.string.req_hide);
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		int banner_mode  = getIntent().getExtras().getInt("banner_mode", 0);
		if (banner_mode == 1) {
			isMREC = true;
		} else if (banner_mode == 2) {
			isVideo = true;
			isMREC = true;
		}

        if (isMREC || isVideo) {
            setContentView(R.layout.activity_banner_mrec);
		}
        else
			setContentView(R.layout.activity_banner);

		layout = (LinearLayout) findViewById(R.id.banner_layout);
		nextAd = (Button) findViewById(R.id.banner_change);
		codeAd = (LinearLayout) findViewById(R.id.banner_code);
		banner_back = (Button) findViewById(R.id.banner_back);
		banner_hide = (Button) findViewById(R.id.banner_hide);
		nextAd.setOnClickListener(this);
		banner_back.setOnClickListener(this);
		codeAd.setOnClickListener(this);
		banner_hide.setOnClickListener(this);
		//get layout height
		LinearLayout container = (LinearLayout) findViewById(R.id.banner_layout_root);
		LinearLayout.LayoutParams para = (LinearLayout.LayoutParams)container.getLayoutParams();
		fullHeight = para.height;
		if (isVideo) {
			banner_hide.setVisibility(View.INVISIBLE);
			LinearLayout videoContainer = (LinearLayout) findViewById(R.id.banner_layout);
			FrameLayout.LayoutParams paramsV = (FrameLayout.LayoutParams)videoContainer.getLayoutParams();
			paramsV.width = -1; //fill_parent
			videoContainer.setLayoutParams(paramsV);
		}

		advListener = new com.advg.loader.loaderInterface.AdViewBannerListener() {
			@Override
			public void onAdClicked() {
				Log.i("AdBannerActivity", "--- banner ---onAdClicked");
			}
			@Override
			public void onAdClosed() {
				Log.i("AdBannerActivity", "--- banner ---onAdClosedAd");
				if (null != adViewBIDView) {
					if (layout != null) {
						layout.removeView(adViewBIDView.getAdViewLayout());
					}
				}
			}
			@Override
			public void onAdDisplayed() {
				Log.i("AdBannerActivity", "--- banner --- onAdDisplayed  ----");
			}
			@Override
			public void onAdFailedReceived(String arg1) {
				if (arg1.contains("Custom://")) {
					Log.i("AdBannerActivity", "--- banner ---onAdRecieveFailed --" + arg1 + "---------");
				}else {
					popupInfo(arg1);
				}
			}
			@Override
			public void onAdReceived() {
				Log.i("AdBannerActivity", "--- banner ---onAdRecieved --------");
			}
			@Override
			public void onAdReady() {
				//if video mode can pass here
				Log.i("AdBannerActivity", "--- banner ---onAdReady --------");
			}

		};

		requestBanner();

		//adViewBIDView.logMode=false;
		//adViewBIDView.setShowCloseBtn(true);
		//adViewBIDView.setOpenAnim(true);

		if (null != layout)
			layout.addView(adViewBIDView.getAdViewLayout());
	}

	@Override
	protected void onResume() {
		super.onResume();
		//foreground-> background

	}
	@Override
	protected void onPause() {
		//foreground -> background
		super.onPause();
	}
    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if(newConfig.orientation==Configuration.ORIENTATION_PORTRAIT){
            Log.i("AdBannerActivity", "--- now portrait ----------------");

        }
        if(newConfig.orientation==Configuration.ORIENTATION_LANDSCAPE){
            Log.i("AdBannerActivity", "--- now landscape ----------------");
        }
        requestBanner();
	}

	@Override
	protected void onDestroy() {
		super.onDestroy();
		Log.i("AdBannerActivity", "---------------- onDestroy ----------------");
		adViewBIDView = null;
	}

	@Override
	public void onClick(View v) {


		if (null == layout)
			return;
//		layout.removeAllViews();


		switch (v.getId()) {

		case R.id.banner_code:
			break;
		case R.id.banner_change:
			if (refreshTime == -1) {
				if (null != adViewBIDView) {
					adViewBIDView.setBannerStopRequest();
					layout.removeView(adViewBIDView.getAdViewLayout());
						adViewBIDView = null;
				}

				requestBanner();
				layout.addView(adViewBIDView.getAdViewLayout());
			}
			break;
		case R.id.banner_back:
				if (null != adViewBIDView) {
				adViewBIDView.setBannerStopRequest();
				}
			this.finish();
			break;
		case R.id.banner_hide:

			if (banner_hide.getText().equals(getResources().getText(R.string.req_hide))) {
				banner_hide.setText(R.string.req_show);
				layout.removeView(adViewBIDView.getAdViewLayout());
			}else {
				banner_hide.setText(R.string.req_hide);
				layout.addView(adViewBIDView.getAdViewLayout());
			}
            break;
		}


	}


	private void popupInfo(String code) {
		AlertDialog.Builder builder;
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
			builder = new AlertDialog.Builder(this, android.R.style.Theme_Material_Dialog_Alert);
		} else {
			builder = new AlertDialog.Builder(this);
		}
		builder.setTitle("Failed to load adview banner ad")
				.setMessage("Error code: \n" + code)
				.setIcon(android.R.drawable.ic_dialog_alert)
				.show();
	}

}
