//
// Copyright 2019 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

#import <UIKit/UIKit.h>

#import "SampleRewardedAd.h"
#import "SampleRewardedAdDelegate.h"

/// This is a rewarded ad. This classs initializes with SampleRewardedAd instance.
@interface SampleRewardedAdController : UIViewController

/// Designated initializer.
- (instancetype)initWithRewardedAd:(SampleRewardedAd *)rewardedAd NS_DESIGNATED_INITIALIZER;

/// Unavailable.
- (instancetype)init NS_UNAVAILABLE;

/// Unavailable.
- (instancetype)initWithNibName:(NSString *)nibNameOrNil
                         bundle:(NSBundle *)nibBundleOrNil NS_UNAVAILABLE;

/// Unavailable.
- (instancetype)initWithCoder:(NSCoder *)aDecoder NS_UNAVAILABLE;

/// Sample rewarded ad delegate.
@property(nonatomic, weak) id<SampleRewardedAdDelegate> delegate;

@end
