//
//  AdViewManager.h
//  AdViewHello
//
//  Created by AdView on 14-9-25.
//
//  Native ads currently only support vast in video

#import "AdViewViewDelegate.h"

@class AdViewRolloverManager;
@class AdViewNativeAd;
@class AdViewNativeData;

@protocol AdViewNativeAdDelegate <AdViewGDPRProcotolV1, AdViewGDPRProcotolV2, AdViewBidModeProtocol>
/*
 * Native AD load AD data callback successfully
 * @param nativeDataArray 为 AdViewNativeData the AD content array
 */
- (void)adViewNativeAdSuccessToLoadAd:(AdViewNativeAd *)adViewNativeAd NativeData:(NSArray <AdViewNativeData *>*)nativeDataArray;

/*
 * Native AD failed to load AD data callback
 * @param error Error message returned for load failure
 */
- (void)adViewNativeAdFailToLoadAd:(AdViewNativeAd *)adViewNativeAd WithError:(NSError *)error;

/*
 * Native ads will be followed by embedded browser callbacks
 */
- (void)adViewNativeAdWillShowPresent;

/*
 * Native ads are clicked back when the embedded browser is closed
 */
- (void)adViewNativeAdClosed;

/*
 * Native ads are clicked and the app is called back when it enters the background
 */
- (void)adViewNativeAdResignActive;
@end

@interface AdViewNativeData : NSObject
@property (nonatomic, strong) NSString * nativeAdId;
@property (nonatomic, strong) NSDictionary * adProperties;
@property (nonatomic, strong) AdViewRolloverManager *rolloverManager;
@end

@interface AdViewNativeAd : NSObject
@property (nonatomic, weak) id<AdViewNativeAdDelegate> delegate;
/*
 * viewControllerForPresentingModalView
 */
@property (nonatomic, weak) UIViewController * controller;

/*
 * Initialization method
 * @param appkey For the application id
 * @param positionID the AD id
 */
- (instancetype)initWithAppKey:(NSString *)appkey positionID:(NSString *)positionID;

/*
 * AD loading method
 * @param count Number of ads requested at one time
 */
- (void)loadNativeAdWithCount:(int)count;

/**
 In the bid mode, you should call it when the delegate method [adViewObject:didReceiveBidPrice:] called back and ther price win.
 It will request ad content & report a result.
 */
- (void)bidSuccess;

/**
 Similar to the use of SEL: bidSuccess.
 It only reports a result
 */
- (void)bidFailure;

/**
 If you need to use OMSDK, be sure to parse these three parameters from the VAST and pass them in before sending the demo report

 @param nativeData Advertising model
 @param vendorKey <Verification vendor="AdView">
 @param verificationScriptURLString <JavaScriptResource apiFramework="omid" browserOptional="true">
 @param verificationParameters <VerificationParameters>
 */
- (void)vastVideoOMSDKAdNativeData:(AdViewNativeData *)nativeData
             setParameterVendorKey:(NSString *)vendorKey
       verificationScriptURLString:(NSString *)verificationScriptURLString
            verificationParameters:(NSString *)verificationParameters
                     videoDuration:(CGFloat)duration
                        skipOffset:(CGFloat)skipOffset
                 videoPlayerVolume:(CGFloat)videoPlayerVolume
                          position:(NSUInteger)position
                          autoPlay:(BOOL)autoPlay;

/*
 * The call method will be displayed after the AD View is rendered (for sending relevant reports)
 * @param nativeData The data object that renders the AD
 * @param view Render the AD page
 */
- (void)showNativeAdWithData:(AdViewNativeData*)nativeData
    friendlyObstructionArray:(NSArray<UIView *> *)friendlyViewArray
                      onView:(UIView*)view;

//OMSDK monitors event points
- (void)reportVideoQuartile:(AdViewOMSDKVideoQuartile)quartile withData:(AdViewNativeData *)nativeData;
- (void)reportVideoSkippedWithData:(AdViewNativeData *)nativeData;
- (void)reportVideoPauseWithData:(AdViewNativeData *)nativeData;
- (void)reportVideoResumeWithData:(AdViewNativeData *)nativeData;
- (void)reportVideoVolumeChangeTo:(CGFloat)playerVolume  withData:(AdViewNativeData *)nativeData;
- (void)videoOrientation:(UIInterfaceOrientation)orientation withData:(AdViewNativeData *)nativeData;

/*
 * Method invoked by AD click
 * When the user clicks on an AD, the developer calls this method, and the SDK responds accordingly (for sending click reports).
 * @param nativeData The data object of the clicked AD
 * @param point Click coordinate, advertising needs users to click the coordinate position, otherwise it will affect revenue; If the advertising view size is (300,200), the point value in the upper left corner is (0,0), and the point value in the lower right corner is (300,200). Take this as an example to calculate the point size.；
 * @param view Render the AD page
 */
- (void)clickNativeAdWithData:(AdViewNativeData *)nativeData
               withClickPoint:(CGPoint)point
                       onView:(UIView *)view;
@end
