<meta charset='utf-8'>
<style type='text/css'>
html,
body {}

* {
    padding: 0px;
    margin: 0px;
}

a:link {
    text-decoration: none;
}

p {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    vertical-align: middle;
}
</style>

<meta name='viewport' content='width=device-width,initial-scale=1,maximum-scale=1'>

<body bgcolor=black onload="playVideo()">

    <video id="VASTVideo" width="100%" height="100%" preload="auto" PLAYSINLINE>
        <source src="VIDEO_FILE" type="video/mp4">
    </video>

    <script type="text/javascript">

    var vid = document.getElementById("VASTVideo");
    var isSkipped = false;
    var isPlayed = false;

    console.namespace = "VAST";
    function callNative(method, args){
        bridge.callNative("VAST", method, args);
    };


    function fixSize(w, h) {
        vid.width = w;
        vid.height = h;
    }

    function playVideo() {
        callNative("size",{"w" : vid.videoWidth, "h" : vid.videoHeight});
        vid.play();
        callNative("isMute",{"mute" : vid.muted});
    }

    function pauseVideo() {
        vid.pause();
    }

    function skipVideo() {
        vid.pause();
        isSkipped = true;
        callNative("skipped");
        vid.currentTime = vid.duration * .92;
    }

    function isMute(isMute) {
        vid.muted = isMute;
        callNative("isMute",{"mute" : vid.muted});
    }

    function getTotalTime() {
        return vid.duration;
    }

    vid.ontimeupdate = function() { 
    	if (!isSkipped) {
            callNative("time", {"time" : vid.currentTime});
        }
    };

    eventListener = function(event) {
        vid.addEventListener(event, function() {
            if (event == "play" && isPlayed) {
                return;
            }
            if (event == "play" && !isPlayed) {
                isPlayed = true;
            }
            callNative(event);
        });
    }

    eventListener("play");
    eventListener("ended");
    eventListener("error");
    </script>

    <script type='text/javascript'>
    var actionDownX, actionDownY;
    var detla = 10;
    var timestamp;
    var mediaView = document.getElementById("VASTVideo");

    mediaView.ontouchstart = function(e) {
        e.preventDefault();
        timestamp = (new Date()).getTime();

        var touch = actionDownTouch = e.touches[0];
        var x = actionDownX = touch.clientX;
        var y = actionDownY = touch.clientY;
    };
    mediaView.ontouchend = function(e) {
        var touch = e.changedTouches[0];
        var x = touch.clientX;
        var y = touch.clientY;
        var tempTime = (new Date()).getTime();
        if (Math.abs(x - actionDownX) <= detla && Math.abs(y - actionDownY) <= detla && tempTime - timestamp < 500) {
            callNative("VASTClick", {"x" : x, "y" : y});
        }
    };
    </script>
</body>
