#import "SceneDelegate.h"
#import <AppTrackingTransparency/AppTrackingTransparency.h>

@interface SceneDelegate ()<AdViewViewDelegate>

@end

@implementation SceneDelegate

- (void)scene:(UIScene *)scene willConnectToSession:(UISceneSession *)session options:(UISceneConnectionOptions *)connectionOptions  API_AVAILABLE(ios(13.0)){
    if (@available(iOS 13.0, *)) {
        UIWindowScene *windowScene = (UIWindowScene *)scene;
        self.window = [[UIWindow alloc] initWithFrame:[UIScreen mainScreen].bounds];
        [self.window setWindowScene:windowScene];
        [self.window setBackgroundColor:[UIColor whiteColor]];
        
        ViewController * vc = [[ViewController alloc] init];
        UINavigationController * navc = [[UINavigationController alloc] initWithRootViewController:vc];
        [self.window setRootViewController:navc];
        [self.window makeKeyAndVisible];
    }
    
    // required, otherwise it will affect your app review
    if (@available(iOS 14.0, *)) {
        [ATTrackingManager requestTrackingAuthorizationWithCompletionHandler:^(ATTrackingManagerAuthorizationStatus status) {
            // your code
        }];
    }
    [AdViewView requestSpreadActivityWithPositionId:ADVIEW_POSID_SPREAD delegate:self];
}


- (void)sceneDidDisconnect:(UIScene *)scene  API_AVAILABLE(ios(13.0)){
    // Called as the scene is being released by the system.
    // This occurs shortly after the scene enters the background, or when its session is discarded.
    // Release any resources associated with this scene that can be re-created the next time the scene connects.
    // The scene may re-connect later, as its session was not neccessarily discarded (see `application:didDiscardSceneSessions` instead).
}


- (void)sceneDidBecomeActive:(UIScene *)scene  API_AVAILABLE(ios(13.0)){
    // Called when the scene has moved from an inactive state to an active state.
    // Use this method to restart any tasks that were paused (or not yet started) when the scene was inactive.
    [self authorizationIDFA];
    
}

- (NSString *)appId {
    return ADVIEW_APPID;
}

- (UIViewController *)viewControllerForShowModal {
    return [[[UIApplication sharedApplication] keyWindow] rootViewController];
}


- (void)sceneWillResignActive:(UIScene *)scene  API_AVAILABLE(ios(13.0)){
    // Called when the scene will move from an active state to an inactive state.
    // This may occur due to temporary interruptions (ex. an incoming phone call).
}


- (void)sceneWillEnterForeground:(UIScene *)scene  API_AVAILABLE(ios(13.0)){
    // Called as the scene transitions from the background to the foreground.
    // Use this method to undo the changes made on entering the background.
}


- (void)sceneDidEnterBackground:(UIScene *)scene  API_AVAILABLE(ios(13.0)){
    // Called as the scene transitions from the foreground to the background.
    // Use this method to save data, release shared resources, and store enough scene-specific state information
    // to restore the scene back to its current state.
}



- (void)authorizationIDFA {
  UIApplication *applicaiton = [UIApplication sharedApplication];
  if (applicaiton.applicationState == UIApplicationStateActive)
  {
      if (@available(iOS 14, *)) {
          ATTrackingManagerAuthorizationStatus status = [ATTrackingManager trackingAuthorizationStatus];
          if(status == ATTrackingManagerAuthorizationStatusNotDetermined){
              [ATTrackingManager requestTrackingAuthorizationWithCompletionHandler:^(ATTrackingManagerAuthorizationStatus status) {
                  // Tracking authorization completed. 
              }];
          }
      }
  }else{
      [self performSelector:@selector(authorizationIDFA)
                     withObject:nil
                     afterDelay:0.5f];
  }
}
@end
