//
//  BannerViewController.m
//  AdViewSDKDemo
//
//  Created by unakayou on 11/1/19.
//  Copyright © 2019 AdView. All rights reserved.
//

#import "BannerViewController.h"

@interface BannerViewController () <AdViewViewDelegate>
@property (nonatomic, strong) AdViewView * banner;
@end

@implementation BannerViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self addSizeCtrlView];
    
}

- (void)requestButtonClick:(UIButton *)sender {
    [self.banner removeFromSuperview];
    self.banner = [AdViewView requestBannerSize:AdViewBannerSize_320x50
                                     bannerType:AdViewBannerType_normal
                                     positionId:ADVIEW_POSID_BANNER
                                       delegate:self];

    [self.backgroundScrollView addSubview:self.banner];
    self.backgroundScrollView.bounds = self.banner.frame;
}

- (void)closeButtonClick:(UITapGestureRecognizer *)recognizer {
    [self.banner removeFromSuperview];
    self.banner = nil;
}

- (void)sliderValueChanged:(UISlider *)slider {
    CGRect bannerFrame = self.banner.frame;
    bannerFrame.size.height *= slider.value;
    if (!CGRectEqualToRect(CGRectZero, bannerFrame)) self.backgroundScrollView.bounds = bannerFrame;
    self.percentLabel.text = [NSString stringWithFormat:@"%.f %%", slider.value * 100];
}

- (NSString *)appId {
    return ADVIEW_APPID;
}

- (UIViewController *)viewControllerForShowModal {
    return self;
}

- (void)didReceivedAd:(AdViewView *)adView {
    NSLog(@"%s",__FUNCTION__);
    [self resetCtrlView];
    self.backgroundScrollView.bounds = self.banner.frame;
}

- (void)didFailToReceiveAd:(AdViewView *)adView Error:(NSError *)error {
    NSLog(@"%s",__FUNCTION__);
    NSLog(@"%@", error);
}
- (void)adViewDidDisplayAd:(AdViewView *)adView {
    
    NSLog(@"%s",__FUNCTION__);
    NSLog(@"Already Displayed");
}
- (void)adViewdidFailToDisplayAd:(AdViewView *)adView Error:(NSError*)error {
    NSLog(@"%s",__FUNCTION__);
    NSLog(@"%@", error);
    
}

- (void)viewDidLayoutSubviews {
    [super viewDidLayoutSubviews];

    CGRect contentFrame = self.backgroundScrollView.frame;
    if (self.banner) {
        contentFrame.origin.x = (self.view.frame.size.width - self.banner.frame.size.width) / 2;
    }
    contentFrame.origin.y = SPACE + 80;
    self.backgroundScrollView.frame = contentFrame;
    self.backgroundScrollView.contentSize = CGSizeMake(0, self.banner.frame.size.height);
    
    CGRect requestButtonFrame = self.requestButton.frame;
    requestButtonFrame.origin.y += SPACE + requestButtonFrame.size.height;
    self.closebutton.frame = requestButtonFrame;
}


@end
